package ru.yandex.qe.dispenser.domain.bot;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Abstract class for {@link BaseConfigurationEntity} and {@link ConfigurationComponent.Attribute}
 *
 * @see BaseConfigurationEntity
 * @see ConfigurationComponent.Attribute
 */
@ParametersAreNonnullByDefault
public abstract class BaseEntity {
    private final Long typeId;
    private final String typeCode;
    private final String typeDisplay;

    protected BaseEntity(final Long typeId, final String typeCode, final String typeDisplay) {
        this.typeId = typeId;
        this.typeCode = typeCode;
        this.typeDisplay = typeDisplay;
    }

    public Long getTypeId() {
        return typeId;
    }

    public String getTypeCode() {
        return typeCode;
    }

    public String getTypeDisplay() {
        return typeDisplay;
    }
}
