package ru.yandex.qe.dispenser.domain.bot;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
@Deprecated
public class BigOrderConfig {

    private static final String UPGRADE_CATEGORY_CODE = "upgrade";

    private final long id;
    private final String typeCode;
    private final String locationKey;
    private final String categoryCode;

    @JsonCreator
    public BigOrderConfig(@JsonProperty("id") long id,
                          @JsonProperty("typeCode") String typeCode,
                          @JsonProperty("locationKey") String locationKey,
                          @JsonProperty("categoryCode") String categoryCode) {
        this.id = id;
        this.typeCode = typeCode;
        this.locationKey = locationKey;
        this.categoryCode = categoryCode;
    }

    public long getId() {
        return id;
    }

    public String getTypeCode() {
        return typeCode;
    }

    public String getLocationKey() {
        return locationKey;
    }

    public String getCategoryCode() {
        return categoryCode;
    }

    @JsonIgnore
    public boolean isUpgrade() {
        return UPGRADE_CATEGORY_CODE.equals(categoryCode);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BigOrderConfig that = (BigOrderConfig) o;
        return id == that.id &&
                Objects.equals(typeCode, that.typeCode) &&
                Objects.equals(locationKey, that.locationKey) &&
                Objects.equals(categoryCode, that.categoryCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, typeCode, locationKey, categoryCode);
    }

    @Override
    public String toString() {
        return "BigOrderConfig{" +
                "id=" + id +
                ", typeCode='" + typeCode + '\'' +
                ", locationKey='" + locationKey + '\'' +
                ", categoryCode='" + categoryCode + '\'' +
                '}';
    }

}
