package ru.yandex.qe.dispenser.domain.bot;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;

import javax.inject.Inject;

import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class BotUtils {

    private final String botPreOrderLinkPrefix;

    @Inject
    public BotUtils(@Value("${bot.pre.order.link.prefix}") final String botPreOrderLinkPrefix) {
        this.botPreOrderLinkPrefix = botPreOrderLinkPrefix;
    }

    @NotNull
    public String getBotPreOrdersUrl(final Collection<Long> botPreOrderIds) {
        return botPreOrderLinkPrefix + "filter=id:"
                + botPreOrderIds.stream().sorted().map(Objects::toString).collect(Collectors.joining(","));
    }
}
