package ru.yandex.qe.dispenser.domain.bot;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.Nullable;

/**
 * Configuration from BOT, used for {@link BotServiceConfiguration}
 * It's subclass of {@link BaseConfigurationEntity}
 *
 * @see BotServiceConfiguration
 * @see BaseConfigurationEntity
 */
@ParametersAreNonnullByDefault
public class Configuration extends BaseConfigurationEntity {
    private final Long id;
    private final Long uniqueId;

    @JsonCreator
    public Configuration(@JsonProperty("id") final Long id, @JsonProperty("unique_id") final Long uniqueId,
                         @JsonProperty("full_name") final String fullName,
                         @JsonProperty("type_id") final Long typeId, @JsonProperty("type_code") final String typeCode,
                         @JsonProperty("type_display") final String typeDisplay,
                         @JsonProperty("enabled") final boolean enabled,
                         @JsonProperty("recommended") final boolean recommended,
                         @Nullable @JsonProperty("description") final String description) {
        super(fullName, typeId, typeCode, typeDisplay, enabled, recommended, description);
        this.id = id;
        this.uniqueId = uniqueId;
    }

    public Long getId() {
        return id;
    }

    public Long getUniqueId() {
        return uniqueId;
    }

    @Override
    public int hashCode() {
        return 31 * id.hashCode() + uniqueId.hashCode();
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final Configuration other = (Configuration) o;
        return this.id.equals(other.id) && this.uniqueId.equals(other.uniqueId);
    }
}
