package ru.yandex.qe.dispenser.domain.bot;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * ConfigurationComponent contains quantity of {@link ConfigurationComponent.Component}
 *
 * @see ConfigurationComponent.Component
 */
@ParametersAreNonnullByDefault
public class ConfigurationComponent {

    private final Long quantity;
    private final Component component;

    public ConfigurationComponent(@JsonProperty("quantity") final Long quantity,
                                  @JsonProperty("component") final Component component) {
        this.quantity = quantity;
        this.component = component;
    }

    public Long getQuantity() {
        return quantity;
    }

    public Component getComponent() {
        return component;
    }

    public static class Component extends BaseConfigurationEntity {

        private final String id;
        private final List<Value> values;

        public Component(@JsonProperty("id") final String id,
                         @JsonProperty("full_name") final String fullName,
                         @JsonProperty("type_id") final Long typeId, @JsonProperty("type_code") final String typeCode,
                         @JsonProperty("type_display") final String typeDisplay,
                         @JsonProperty("enabled") final boolean enabled,
                         @JsonProperty("recommended") final boolean recommended,
                         @Nullable @JsonProperty("description") final String description,
                         @JsonProperty("values") final List<Value> values) {
            super(fullName, typeId, typeCode, typeDisplay, enabled, recommended, description);
            this.id = id;
            this.values = values;
        }

        public String getId() {
            return id;
        }

        public List<Value> getValues() {
            return values;
        }
    }

    public static class Value {

        private final Attribute attribute;
        @Nullable
        private final String stringValue;
        @Nullable
        private final Integer integerValue;
        @Nullable
        private final Double floatValue;
        @Nullable
        private final Boolean booleanValue;

        public Value(@JsonProperty("attribute") final Attribute attribute,
                     @Nullable @JsonProperty("string_value") final String stringValue,
                     @Nullable @JsonProperty("integer_value") final Integer integerValue,
                     @Nullable @JsonProperty("float_value") final Double floatValue,
                     @Nullable @JsonProperty("boolean_value") final Boolean booleanValue) {
            this.attribute = attribute;
            this.stringValue = stringValue;
            this.integerValue = integerValue;
            this.floatValue = floatValue;
            this.booleanValue = booleanValue;
        }

        public Attribute getAttribute() {
            return attribute;
        }

        @Nullable
        public String getStringValue() {
            return stringValue;
        }

        @Nullable
        public Integer getIntegerValue() {
            return integerValue;
        }

        @Nullable
        public Double getFloatValue() {
            return floatValue;
        }

        @Nullable
        public Boolean getBooleanValue() {
            return booleanValue;
        }
    }

    public static class Attribute extends BaseEntity {
        private final String id;
        private final String name;

        public Attribute(@JsonProperty("type_id") final Long typeId,
                         @JsonProperty("type_code") final String typeCode,
                         @JsonProperty("type_display") final String typeDisplay,
                         @JsonProperty("id") final String id,
                         @JsonProperty("name") final String name) {
            super(typeId, typeCode, typeDisplay);
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return id;
        }

        public String getName() {
            return name;
        }
    }
}
