package ru.yandex.qe.dispenser.domain.bot;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * ConfigurationWithComponents contains {@link ConfigurationComponent}
 * It's subclass of {@link Configuration}
 *
 * @see ConfigurationComponent
 * @see Configuration
 */
@ParametersAreNonnullByDefault
public class ConfigurationWithComponents extends Configuration {

    @NotNull
    private final List<ConfigurationComponent> configurationComponents;

    public ConfigurationWithComponents(@JsonProperty("id") final Long id, @JsonProperty("unique_id") final Long uniqueId,
                                       @JsonProperty("full_name") final String fullName,
                                       @JsonProperty("type_id") final Long typeId, @JsonProperty("type_code") final String typeCode,
                                       @JsonProperty("type_display") final String typeDisplay,
                                       @JsonProperty("enabled") final boolean enabled,
                                       @JsonProperty("recommended") final boolean recommended,
                                       @Nullable @JsonProperty("description") final String description,
                                       @JsonProperty("configuration_components") final List<ConfigurationComponent> configurationComponents) {
        super(id, uniqueId, fullName, typeId, typeCode, typeDisplay, enabled, recommended, description);

        this.configurationComponents = configurationComponents;
    }


    @NotNull
    public List<ConfigurationComponent> getConfigurationComponents() {
        return configurationComponents;
    }
}
