package ru.yandex.qe.dispenser.domain.d;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

/**
 * Amount dto.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class AmountDto {
    @NotNull
    private final String readableAmount;
    @NotNull
    private final String readableUnit;
    @NotNull
    private final String rawAmount;
    @NotNull
    private final String rawUnit;
    @NotNull
    private final String forEditAmount;
    @NotNull
    private final String forEditUnitId;
    @NotNull
    private final String amountInMinAllowedUnit;
    @NotNull
    private final String minAllowedUnit;

    @JsonCreator
    public AmountDto(
            @JsonProperty(value = "readableAmount", required = true) @NotNull String readableAmount,
            @JsonProperty(value = "readableUnit", required = true) @NotNull String readableUnit,
            @JsonProperty(value = "rawAmount", required = true) @NotNull String rawAmount,
            @JsonProperty(value = "rawUnit", required = true) @NotNull String rawUnit,
            @JsonProperty(value = "forEditAmount", required = true) @NotNull String forEditAmount,
            @JsonProperty(value = "forEditUnitId", required = true) @NotNull String forEditUnitId,
            @JsonProperty(value = "amountInMinAllowedUnit", required = true) @NotNull String amountInMinAllowedUnit,
            @JsonProperty(value = "minAllowedUnit", required = true) @NotNull String minAllowedUnit) {
        this.readableAmount = readableAmount;
        this.readableUnit = readableUnit;
        this.rawAmount = rawAmount;
        this.rawUnit = rawUnit;
        this.forEditAmount = forEditAmount;
        this.forEditUnitId = forEditUnitId;
        this.amountInMinAllowedUnit = amountInMinAllowedUnit;
        this.minAllowedUnit = minAllowedUnit;
    }

    @NotNull
    public String getReadableAmount() {
        return readableAmount;
    }

    @NotNull
    public String getReadableUnit() {
        return readableUnit;
    }

    @NotNull
    public String getRawAmount() {
        return rawAmount;
    }

    @NotNull
    public String getRawUnit() {
        return rawUnit;
    }

    @NotNull
    public String getForEditAmount() {
        return forEditAmount;
    }

    @NotNull
    public String getForEditUnitId() {
        return forEditUnitId;
    }

    @NotNull
    public String getAmountInMinAllowedUnit() {
        return amountInMinAllowedUnit;
    }

    @NotNull
    public String getMinAllowedUnit() {
        return minAllowedUnit;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AmountDto amountDto = (AmountDto) o;
        return Objects.equals(readableAmount, amountDto.readableAmount) && Objects.equals(readableUnit,
                amountDto.readableUnit) && Objects.equals(rawAmount, amountDto.rawAmount) && Objects.equals(rawUnit,
                amountDto.rawUnit) && Objects.equals(forEditAmount, amountDto.forEditAmount)
                && Objects.equals(forEditUnitId, amountDto.forEditUnitId)
                && Objects.equals(amountInMinAllowedUnit, amountDto.amountInMinAllowedUnit)
                && Objects.equals(minAllowedUnit, amountDto.minAllowedUnit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(readableAmount, readableUnit, rawAmount, rawUnit, forEditAmount, forEditUnitId,
                amountInMinAllowedUnit, minAllowedUnit);
    }

    @Override
    public String toString() {
        return "AmountDto{" +
                "readableAmount='" + readableAmount + '\'' +
                ", readableUnit='" + readableUnit + '\'' +
                ", rawAmount='" + rawAmount + '\'' +
                ", rawUnit='" + rawUnit + '\'' +
                ", forEditAmount='" + forEditAmount + '\'' +
                ", forEditUnitId='" + forEditUnitId + '\'' +
                ", amountInMinAllowedUnit='" + amountInMinAllowedUnit + '\'' +
                ", minAllowedUnit='" + minAllowedUnit + '\'' +
                '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String readableAmount;
        private String readableUnit;
        private String rawAmount;
        private String rawUnit;
        private String forEditAmount;
        private String forEditUnitId;
        private String amountInMinAllowedUnit;
        private String minAllowedUnit;

        public Builder readableAmount(String readableAmount) {
            this.readableAmount = readableAmount;
            return this;
        }

        public Builder readableUnit(String readableUnit) {
            this.readableUnit = readableUnit;
            return this;
        }

        public Builder rawAmount(String rawAmount) {
            this.rawAmount = rawAmount;
            return this;
        }

        public Builder rawUnit(String rawUnit) {
            this.rawUnit = rawUnit;
            return this;
        }

        public Builder forEditAmount(String forEditAmount) {
            this.forEditAmount = forEditAmount;
            return this;
        }

        public Builder forEditUnitId(String forEditUnitId) {
            this.forEditUnitId = forEditUnitId;
            return this;
        }

        public Builder amountInMinAllowedUnit(String amountInMinAllowedUnit) {
            this.amountInMinAllowedUnit = amountInMinAllowedUnit;
            return this;
        }

        public Builder minAllowedUnit(String minAllowedUnit) {
            this.minAllowedUnit = minAllowedUnit;
            return this;
        }

        public AmountDto build() {
            return new AmountDto(
                    Objects.requireNonNull(readableAmount, "ReadableAmount is required!"),
                    Objects.requireNonNull(readableUnit, "ReadableUnit is required!"),
                    Objects.requireNonNull(rawAmount, "RawAmount is required!"),
                    Objects.requireNonNull(rawUnit, "RawUnit is required!"),
                    Objects.requireNonNull(forEditAmount, "ForEditAmount is required!"),
                    Objects.requireNonNull(forEditUnitId, "ForEditUnitId is required!"),
                    Objects.requireNonNull(amountInMinAllowedUnit, "AmountInMinAllowedUnit is required!"),
                    Objects.requireNonNull(minAllowedUnit, "MinAllowedUnit is required!")
            );
        }
    }
}
