package ru.yandex.qe.dispenser.domain.d;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

import org.springframework.web.bind.annotation.RequestBody;

@Path("api/v1/delivery")
@Produces({"application/json"})
@Consumes({"application/json"})
public interface DApi {

    @POST
    @Path("_deliver")
    DeliveryResponseDto deliver(@RequestBody DeliveryRequestDto deliveryRequest);

    @POST
    @Path("_provide")
    ProvideResponseDto provide(@RequestBody ProvideRequestDto provideRequestDto);

    @POST
    @Path("/_findDestinations")
    DeliveryDestinationResponseDto findDestinations(@QueryParam("lang") String lang,
                                                    @RequestBody DeliveryDestinationRequestDto request);

    @POST
    @Path("/_status")
    DeliveryStatusResponseDto getStatuses(@QueryParam("lang") String lang, @RequestBody List<String> deliveryIds);

}
