package ru.yandex.qe.dispenser.domain.d;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public final class DeliverableDeltaDto {

    private final long amount;
    private final String unitKey;

    @JsonCreator
    public DeliverableDeltaDto(@JsonProperty("amount") long amount,
                               @JsonProperty("unitKey") String unitKey) {
        this.amount = amount;
        this.unitKey = unitKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getAmount() {
        return amount;
    }

    public String getUnitKey() {
        return unitKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliverableDeltaDto that = (DeliverableDeltaDto) o;
        return Objects.equals(amount, that.amount) &&
                Objects.equals(unitKey, that.unitKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(amount, unitKey);
    }

    @Override
    public String toString() {
        return "DeliverableDeltaDto{" +
                "amount=" + amount +
                ", unitKey='" + unitKey + '\'' +
                '}';
    }

    public static final class Builder {

        private Long amount;
        private String unitKey;

        private Builder() {
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public Builder unitKey(String unitKey) {
            this.unitKey = unitKey;
            return this;
        }

        public DeliverableDeltaDto build() {
            Objects.requireNonNull(amount, "Amount is required");
            Objects.requireNonNull(unitKey, "Unit key is required");
            return new DeliverableDeltaDto(amount, unitKey);
        }

    }

}
