package ru.yandex.qe.dispenser.domain.d;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public final class DeliverableMetaRequestDto {

    private final long quotaRequestId;
    private final long campaignId;
    private final long bigOrderId;

    @JsonCreator
    public DeliverableMetaRequestDto(@JsonProperty("quotaRequestId") long quotaRequestId,
                                     @JsonProperty("campaignId") long campaignId,
                                     @JsonProperty("bigOrderId") long bigOrderId) {
        this.quotaRequestId = quotaRequestId;
        this.campaignId = campaignId;
        this.bigOrderId = bigOrderId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getQuotaRequestId() {
        return quotaRequestId;
    }

    public long getCampaignId() {
        return campaignId;
    }

    public long getBigOrderId() {
        return bigOrderId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliverableMetaRequestDto that = (DeliverableMetaRequestDto) o;
        return quotaRequestId == that.quotaRequestId &&
                campaignId == that.campaignId &&
                bigOrderId == that.bigOrderId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(quotaRequestId, campaignId, bigOrderId);
    }

    @Override
    public String toString() {
        return "DeliverableMetaRequestDto{" +
                "quotaRequestId=" + quotaRequestId +
                ", campaignId=" + campaignId +
                ", bigOrderId=" + bigOrderId +
                '}';
    }

    public static final class Builder {

        private Long quotaRequestId;
        private Long campaignId;
        private Long bigOrderId;

        private Builder() {
        }

        public Builder quotaRequestId(long quotaRequestId) {
            this.quotaRequestId = quotaRequestId;
            return this;
        }

        public Builder campaignId(long campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder bigOrderId(long bigOrderId) {
            this.bigOrderId = bigOrderId;
            return this;
        }

        public DeliverableMetaRequestDto build() {
            Objects.requireNonNull(quotaRequestId, "Quota request idd is required");
            Objects.requireNonNull(campaignId, "Campaign id is required");
            Objects.requireNonNull(bigOrderId, "Big order id is required");
            return new DeliverableMetaRequestDto(quotaRequestId, campaignId, bigOrderId);
        }

    }

}
