package ru.yandex.qe.dispenser.domain.d;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;

@JsonIgnoreProperties(ignoreUnknown = true)
public final class DeliverableMetaResponseDto {

    private final Long quotaRequestId;
    private final Long campaignId;
    private final Long bigOrderId;

    @JsonCreator
    public DeliverableMetaResponseDto(@JsonProperty("quotaRequestId") Long quotaRequestId,
                                      @JsonProperty("campaignId") Long campaignId,
                                      @JsonProperty("bigOrderId") Long bigOrderId) {
        this.quotaRequestId = quotaRequestId;
        this.campaignId = campaignId;
        this.bigOrderId = bigOrderId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Long getQuotaRequestId() {
        return quotaRequestId;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public Long getBigOrderId() {
        return bigOrderId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliverableMetaResponseDto that = (DeliverableMetaResponseDto) o;
        return Objects.equals(quotaRequestId, that.quotaRequestId) &&
                Objects.equals(campaignId, that.campaignId) &&
                Objects.equals(bigOrderId, that.bigOrderId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(quotaRequestId, campaignId, bigOrderId);
    }

    @Override
    public String toString() {
        return "DeliverableMetaResponseDto{" +
                "quotaRequestId=" + quotaRequestId +
                ", campaignId=" + campaignId +
                ", bigOrderId=" + bigOrderId +
                '}';
    }

    public static final class Builder {

        private Long quotaRequestId;
        private Long campaignId;
        private Long bigOrderId;

        private Builder() {
        }

        public Builder setQuotaRequestId(long quotaRequestId) {
            this.quotaRequestId = quotaRequestId;
            return this;
        }

        public Builder setCampaignId(long campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder setBigOrderId(long bigOrderId) {
            this.bigOrderId = bigOrderId;
            return this;
        }

        public DeliverableMetaResponseDto build() {
            Preconditions.checkNotNull(quotaRequestId, "QuotaRequestId is required");
            Preconditions.checkNotNull(campaignId, "CampaignId is required");
            Preconditions.checkNotNull(bigOrderId, "BigOrderId is required");
            return new DeliverableMetaResponseDto(quotaRequestId, campaignId, bigOrderId);
        }

    }

}
