package ru.yandex.qe.dispenser.domain.d;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DeliveryAccountDto {

    private final String id;
    private final String externalId;
    private final String externalKey;
    private final String displayName;
    private final String folderId;
    private final String folderName;

    @JsonCreator
    public DeliveryAccountDto(@JsonProperty("id") String id,
                              @JsonProperty("externalId") String externalId,
                              @JsonProperty("externalKey") String externalKey,
                              @JsonProperty("displayName") String displayName,
                              @JsonProperty("folderId") String folderId,
                              @JsonProperty("folderName") String folderName) {
        this.id = id;
        this.externalId = externalId;
        this.externalKey = externalKey;
        this.displayName = displayName;
        this.folderId = folderId;
        this.folderName = folderName;
    }

    public String getId() {
        return id;
    }

    public String getExternalId() {
        return externalId;
    }

    public Optional<String> getExternalKey() {
        return Optional.ofNullable(externalKey);
    }

    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public String getFolderId() {
        return folderId;
    }

    public String getFolderName() {
        return folderName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliveryAccountDto that = (DeliveryAccountDto) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(externalId, that.externalId) &&
                Objects.equals(externalKey, that.externalKey) &&
                Objects.equals(displayName, that.displayName) &&
                Objects.equals(folderId, that.folderId) &&
                Objects.equals(folderName, that.folderName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, externalId, externalKey, displayName, folderId, folderName);
    }

    @Override
    public String toString() {
        return "DeliveryAccountDto{" +
                "id='" + id + '\'' +
                ", externalId='" + externalId + '\'' +
                ", externalKey='" + externalKey + '\'' +
                ", displayName='" + displayName + '\'' +
                ", folderId='" + folderId + '\'' +
                ", folderName='" + folderName + '\'' +
                '}';
    }

}
