package ru.yandex.qe.dispenser.domain.d;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DeliveryAccountsSpaceDto {

    private final String id;
    private final String name;
    private final String key;
    private final boolean eligible;
    private final List<String> ineligibilityReasons;
    private final DeliveryResourcesAccountsDto resourcesAccounts;

    @JsonCreator
    public DeliveryAccountsSpaceDto(@JsonProperty("id") String id,
                                    @JsonProperty("name") String name,
                                    @JsonProperty("key") String key,
                                    @JsonProperty("eligible") boolean eligible,
                                    @JsonProperty("ineligibilityReasons") List<String> ineligibilityReasons,
                                    @JsonProperty("resourcesAccounts") DeliveryResourcesAccountsDto resourcesAccounts) {
        this.id = id;
        this.name = name;
        this.key = key;
        this.eligible = eligible;
        this.ineligibilityReasons = ineligibilityReasons != null ? ineligibilityReasons : List.of();
        this.resourcesAccounts = resourcesAccounts;
    }

    public String getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getKey() {
        return key;
    }

    public boolean isEligible() {
        return eligible;
    }

    public List<String> getIneligibilityReasons() {
        return ineligibilityReasons;
    }

    public DeliveryResourcesAccountsDto getResourcesAccounts() {
        return resourcesAccounts;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliveryAccountsSpaceDto that = (DeliveryAccountsSpaceDto) o;
        return eligible == that.eligible &&
                Objects.equals(id, that.id) &&
                Objects.equals(name, that.name) &&
                Objects.equals(key, that.key) &&
                Objects.equals(ineligibilityReasons, that.ineligibilityReasons) &&
                Objects.equals(resourcesAccounts, that.resourcesAccounts);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, key, eligible, ineligibilityReasons, resourcesAccounts);
    }

    @Override
    public String toString() {
        return "DeliveryAccountsSpaceDto{" +
                "id='" + id + '\'' +
                ", name='" + name + '\'' +
                ", key='" + key + '\'' +
                ", eligible=" + eligible +
                ", ineligibilityReasons=" + ineligibilityReasons +
                ", resourcesAccounts=" + resourcesAccounts +
                '}';
    }

}
