package ru.yandex.qe.dispenser.domain.d;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DeliveryAmountDto {

    private final String readableAmount;
    private final String readableUnit;
    private final String rawAmount;
    private final String rawUnit;
    private final String forEditAmount;
    private final String forEditUnitId;
    private final String amountInMinAllowedUnit;
    private final String minAllowedUnit;

    @JsonCreator
    public DeliveryAmountDto(@JsonProperty("readableAmount") String readableAmount,
                             @JsonProperty("readableUnit") String readableUnit,
                             @JsonProperty("rawAmount") String rawAmount,
                             @JsonProperty("rawUnit") String rawUnit,
                             @JsonProperty("forEditAmount") String forEditAmount,
                             @JsonProperty("forEditUnitId") String forEditUnitId,
                             @JsonProperty("amountInMinAllowedUnit") String amountInMinAllowedUnit,
                             @JsonProperty("minAllowedUnit") String minAllowedUnit) {
        this.readableAmount = readableAmount;
        this.readableUnit = readableUnit;
        this.rawAmount = rawAmount;
        this.rawUnit = rawUnit;
        this.forEditAmount = forEditAmount;
        this.forEditUnitId = forEditUnitId;
        this.amountInMinAllowedUnit = amountInMinAllowedUnit;
        this.minAllowedUnit = minAllowedUnit;
    }

    public String getReadableAmount() {
        return readableAmount;
    }

    public String getReadableUnit() {
        return readableUnit;
    }

    public String getRawAmount() {
        return rawAmount;
    }

    public String getRawUnit() {
        return rawUnit;
    }

    public String getForEditAmount() {
        return forEditAmount;
    }

    public String getForEditUnitId() {
        return forEditUnitId;
    }

    public String getAmountInMinAllowedUnit() {
        return amountInMinAllowedUnit;
    }

    public String getMinAllowedUnit() {
        return minAllowedUnit;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliveryAmountDto that = (DeliveryAmountDto) o;
        return Objects.equals(readableAmount, that.readableAmount) &&
                Objects.equals(readableUnit, that.readableUnit) &&
                Objects.equals(rawAmount, that.rawAmount) &&
                Objects.equals(rawUnit, that.rawUnit) &&
                Objects.equals(forEditAmount, that.forEditAmount) &&
                Objects.equals(forEditUnitId, that.forEditUnitId) &&
                Objects.equals(amountInMinAllowedUnit, that.amountInMinAllowedUnit) &&
                Objects.equals(minAllowedUnit, that.minAllowedUnit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(readableAmount, readableUnit, rawAmount, rawUnit, forEditAmount, forEditUnitId,
                amountInMinAllowedUnit, minAllowedUnit);
    }

    @Override
    public String toString() {
        return "DeliveryAmountDto{" +
                "readableAmount='" + readableAmount + '\'' +
                ", readableUnit='" + readableUnit + '\'' +
                ", rawAmount='" + rawAmount + '\'' +
                ", rawUnit='" + rawUnit + '\'' +
                ", forEditAmount='" + forEditAmount + '\'' +
                ", forEditUnitId='" + forEditUnitId + '\'' +
                ", amountInMinAllowedUnit='" + amountInMinAllowedUnit + '\'' +
                ", minAllowedUnit='" + minAllowedUnit + '\'' +
                '}';
    }

}
