package ru.yandex.qe.dispenser.domain.d;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DeliveryAndProvideMetaRequestDto {
    private final long quotaRequestId;
    private final long campaignId;
    private final Set<Long> bigOrderIds;

    @JsonCreator
    public DeliveryAndProvideMetaRequestDto(@JsonProperty("quotaRequestId") long quotaRequestId,
                                            @JsonProperty("campaignId") long campaignId,
                                            @JsonProperty("bigOrderIds") Set<Long> bigOrderIds) {
        this.quotaRequestId = quotaRequestId;
        this.campaignId = campaignId;
        this.bigOrderIds = ImmutableSet.copyOf(bigOrderIds);
    }

    public long getQuotaRequestId() {
        return quotaRequestId;
    }

    public long getCampaignId() {
        return campaignId;
    }

    public Set<Long> getBigOrderIds() {
        return bigOrderIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliveryAndProvideMetaRequestDto that = (DeliveryAndProvideMetaRequestDto) o;
        return quotaRequestId == that.quotaRequestId && campaignId == that.campaignId && Objects.equals(bigOrderIds,
                that.bigOrderIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(quotaRequestId, campaignId, bigOrderIds);
    }

    @Override
    public String toString() {
        return "DeliveryAndProvideMetaRequestDto{" +
                "quotaRequestId=" + quotaRequestId +
                ", campaignId=" + campaignId +
                ", bigOrderIds=" + bigOrderIds +
                '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Long quotaRequestId;
        private Long campaignId;
        private final Set<Long> bigOrderIds = new HashSet<>();

        public Builder quotaRequestId(long quotaRequestId) {
            this.quotaRequestId = quotaRequestId;
            return this;
        }

        public Builder campaignId(long campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder addBigOrderId(long bigOrderId) {
            this.bigOrderIds.add(bigOrderId);
            return this;
        }

        public Builder addBigOrderIds(Collection<Long> bigOrderIds) {
            this.bigOrderIds.addAll(bigOrderIds);
            return this;
        }

        public DeliveryAndProvideMetaRequestDto build() {
            if (bigOrderIds.isEmpty()) {
                throw new IllegalArgumentException("Big order id must be provided");
            }
            return new DeliveryAndProvideMetaRequestDto(
                    Objects.requireNonNull(quotaRequestId, "Quota request idd is required"),
                    Objects.requireNonNull(campaignId, "Campaign id is required"),
                    bigOrderIds
            );
        }
    }
}
