package ru.yandex.qe.dispenser.domain.d;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DeliveryDestinationDto {

    private final long serviceId;
    private final long quotaRequestId;
    private final List<String> resourceIds;

    @JsonCreator
    public DeliveryDestinationDto(@JsonProperty("serviceId") long serviceId,
                                  @JsonProperty("quotaRequestId") long quotaRequestId,
                                  @JsonProperty("resourceIds") List<String> resourceIds) {
        this.serviceId = serviceId;
        this.quotaRequestId = quotaRequestId;
        this.resourceIds = resourceIds;
    }

    public long getServiceId() {
        return serviceId;
    }

    public long getQuotaRequestId() {
        return quotaRequestId;
    }

    public List<String> getResourceIds() {
        return resourceIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliveryDestinationDto that = (DeliveryDestinationDto) o;
        return serviceId == that.serviceId &&
                quotaRequestId == that.quotaRequestId &&
                Objects.equals(resourceIds, that.resourceIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(serviceId, quotaRequestId, resourceIds);
    }

    @Override
    public String toString() {
        return "DeliveryDestinationDto{" +
                "serviceId=" + serviceId +
                ", quotaRequestId=" + quotaRequestId +
                ", resourceIds=" + resourceIds +
                '}';
    }

}
