package ru.yandex.qe.dispenser.domain.d;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DeliveryDestinationProvidersDto {

    private final long serviceId;
    private final long quotaRequestId;
    private final boolean eligible;
    private final List<String> ineligibilityReasons;
    private final List<DeliveryProviderDto> providers;

    @JsonCreator
    public DeliveryDestinationProvidersDto(@JsonProperty("serviceId") long serviceId,
                                           @JsonProperty("quotaRequestId") long quotaRequestId,
                                           @JsonProperty("eligible") boolean eligible,
                                           @JsonProperty("ineligibilityReasons") List<String> ineligibilityReasons,
                                           @JsonProperty("providers") List<DeliveryProviderDto> providers) {
        this.serviceId = serviceId;
        this.quotaRequestId = quotaRequestId;
        this.eligible = eligible;
        this.ineligibilityReasons = ineligibilityReasons != null ? ineligibilityReasons : List.of();
        this.providers = providers != null ? providers : List.of();
    }

    public long getServiceId() {
        return serviceId;
    }

    public long getQuotaRequestId() {
        return quotaRequestId;
    }

    public boolean isEligible() {
        return eligible;
    }

    public List<String> getIneligibilityReasons() {
        return ineligibilityReasons;
    }

    public List<DeliveryProviderDto> getProviders() {
        return providers;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliveryDestinationProvidersDto that = (DeliveryDestinationProvidersDto) o;
        return serviceId == that.serviceId &&
                quotaRequestId == that.quotaRequestId &&
                eligible == that.eligible &&
                Objects.equals(ineligibilityReasons, that.ineligibilityReasons) &&
                Objects.equals(providers, that.providers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(serviceId, quotaRequestId, eligible, ineligibilityReasons, providers);
    }

    @Override
    public String toString() {
        return "DeliveryDestinationProvidersDto{" +
                "serviceId=" + serviceId +
                ", quotaRequestId=" + quotaRequestId +
                ", eligible=" + eligible +
                ", ineligibilityReasons=" + ineligibilityReasons +
                ", providers=" + providers +
                '}';
    }

}
