package ru.yandex.qe.dispenser.domain.d;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DeliveryDestinationRequestDto {

    private final String userUid;
    private final List<DeliveryDestinationDto> deliverables;

    @JsonCreator
    public DeliveryDestinationRequestDto(@JsonProperty("userUid") String userUid,
                                         @JsonProperty("deliverables") List<DeliveryDestinationDto> deliverables) {
        this.userUid = userUid;
        this.deliverables = deliverables;
    }

    public String getUserUid() {
        return userUid;
    }

    public List<DeliveryDestinationDto> getDeliverables() {
        return deliverables;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliveryDestinationRequestDto that = (DeliveryDestinationRequestDto) o;
        return Objects.equals(userUid, that.userUid) &&
                Objects.equals(deliverables, that.deliverables);
    }

    @Override
    public int hashCode() {
        return Objects.hash(userUid, deliverables);
    }

    @Override
    public String toString() {
        return "DeliveryDestinationRequestDto{" +
                "userUid='" + userUid + '\'' +
                ", deliverables=" + deliverables +
                '}';
    }

}
