package ru.yandex.qe.dispenser.domain.d;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DeliveryDestinationResourceDto {

    private final String id;
    private final String key;
    private final String name;
    private final boolean eligible;
    private final List<String> ineligibilityReasons;

    @JsonCreator
    public DeliveryDestinationResourceDto(@JsonProperty("id") String id,
                                          @JsonProperty("key") String key,
                                          @JsonProperty("name") String name,
                                          @JsonProperty("eligible") boolean eligible,
                                          @JsonProperty("ineligibilityReasons") List<String> ineligibilityReasons) {
        this.id = id;
        this.key = key;
        this.name = name;
        this.eligible = eligible;
        this.ineligibilityReasons = ineligibilityReasons != null ? ineligibilityReasons : List.of();
    }

    public String getId() {
        return id;
    }

    public String getKey() {
        return key;
    }

    public String getName() {
        return name;
    }

    public boolean getEligible() {
        return eligible;
    }

    public List<String> getIneligibilityReasons() {
        return ineligibilityReasons;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliveryDestinationResourceDto that = (DeliveryDestinationResourceDto) o;
        return eligible == that.eligible &&
                Objects.equals(id, that.id) &&
                Objects.equals(key, that.key) &&
                Objects.equals(name, that.name) &&
                Objects.equals(ineligibilityReasons, that.ineligibilityReasons);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, key, name, eligible, ineligibilityReasons);
    }

    @Override
    public String toString() {
        return "DeliveryDestinationResourceDto{" +
                "id='" + id + '\'' +
                ", key='" + key + '\'' +
                ", name='" + name + '\'' +
                ", eligible=" + eligible +
                ", ineligibilityReasons=" + ineligibilityReasons +
                '}';
    }

}
