package ru.yandex.qe.dispenser.domain.d;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DeliveryDestinationResponseDto {

    private final List<DeliveryDestinationProvidersDto> destinations;
    private final List<DeliveryDestinationResourceDto> resources;

    @JsonCreator
    public DeliveryDestinationResponseDto(
            @JsonProperty("destinations") List<DeliveryDestinationProvidersDto> destinations,
            @JsonProperty("resources") List<DeliveryDestinationResourceDto> resources) {
        this.destinations = destinations != null ? destinations : List.of();
        this.resources = resources != null ? resources : List.of();
    }

    public List<DeliveryDestinationProvidersDto> getDestinations() {
        return destinations;
    }

    public List<DeliveryDestinationResourceDto> getResources() {
        return resources;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliveryDestinationResponseDto that = (DeliveryDestinationResponseDto) o;
        return Objects.equals(destinations, that.destinations) &&
                Objects.equals(resources, that.resources);
    }

    @Override
    public int hashCode() {
        return Objects.hash(destinations, resources);
    }

    @Override
    public String toString() {
        return "DeliveryDestinationResponseDto{" +
                "destinations=" + destinations +
                ", resources=" + resources +
                '}';
    }

}
