package ru.yandex.qe.dispenser.domain.d;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.jetbrains.annotations.Nullable;

public enum DeliveryOperationErrorKindDto {

    UNKNOWN_KIND_VALUE,
    INVALID_ARGUMENT,
    ALREADY_EXISTS,
    FAILED_PRECONDITION,
    UNKNOWN,
    ABORTED,
    UNDEFINED,
    EXPIRED;

    @JsonValue
    public String toJsonValue() {
        return name();
    }

    @Nullable
    @JsonCreator
    public static DeliveryOperationErrorKindDto fromJsonValue(@Nullable String value) {
        if (value == null) {
            return null;
        }
        try {
            return DeliveryOperationErrorKindDto.valueOf(value);
        } catch (IllegalArgumentException e) {
            return DeliveryOperationErrorKindDto.UNKNOWN_KIND_VALUE;
        }
    }

}
