package ru.yandex.qe.dispenser.domain.d;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.jetbrains.annotations.Nullable;

public enum DeliveryOperationStatusDto {

    UNKNOWN_STATUS_VALUE,
    IN_PROGRESS,
    SUCCESS,
    FAILURE;

    @JsonValue
    public String toJsonValue() {
        return name();
    }

    @Nullable
    @JsonCreator
    public static DeliveryOperationStatusDto fromJsonValue(@Nullable String value) {
        if (value == null) {
            return null;
        }
        try {
            return DeliveryOperationStatusDto.valueOf(value);
        } catch (IllegalArgumentException e) {
            return DeliveryOperationStatusDto.UNKNOWN_STATUS_VALUE;
        }
    }

}
