package ru.yandex.qe.dispenser.domain.d;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DeliveryResourceSegmentationSegmentDto {

    private final String segmentationId;
    @Nullable
    private final String segmentationName;
    @Nullable
    private final Long groupingOrder;
    private final String segmentId;
    @Nullable
    private final String segmentName;

    @JsonCreator
    public DeliveryResourceSegmentationSegmentDto(@JsonProperty("segmentationId") String segmentationId,
                                                  @JsonProperty("segmentationName") @Nullable String segmentationName,
                                                  @JsonProperty("groupingOrder") @Nullable Long groupingOrder,
                                                  @JsonProperty("segmentId") String segmentId,
                                                  @JsonProperty("segmentName") @Nullable String segmentName) {
        this.segmentationId = segmentationId;
        this.segmentationName = segmentationName;
        this.groupingOrder = groupingOrder;
        this.segmentId = segmentId;
        this.segmentName = segmentName;
    }

    public String getSegmentationId() {
        return segmentationId;
    }

    @Nullable
    public String getSegmentationName() {
        return segmentationName;
    }

    @Nullable
    public Long getGroupingOrder() {
        return groupingOrder;
    }

    public String getSegmentId() {
        return segmentId;
    }

    @Nullable
    public String getSegmentName() {
        return segmentName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliveryResourceSegmentationSegmentDto that = (DeliveryResourceSegmentationSegmentDto) o;
        return Objects.equals(segmentationId, that.segmentationId) &&
                Objects.equals(segmentationName, that.segmentationName) &&
                Objects.equals(groupingOrder, that.groupingOrder) &&
                Objects.equals(segmentId, that.segmentId) &&
                Objects.equals(segmentName, that.segmentName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(segmentationId, segmentationName, groupingOrder, segmentId, segmentName);
    }

    @Override
    public String toString() {
        return "DeliveryResourceSegmentationSegmentDto{" +
                "segmentationId='" + segmentationId + '\'' +
                ", segmentationName='" + segmentationName + '\'' +
                ", groupingOrder=" + groupingOrder +
                ", segmentId='" + segmentId + '\'' +
                ", segmentName='" + segmentName + '\'' +
                '}';
    }

}
