package ru.yandex.qe.dispenser.domain.d;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DeliveryResourcesAccountsDto {

    private final List<String> resourceIds;
    private final List<DeliveryAccountDto> accounts;

    @JsonCreator
    public DeliveryResourcesAccountsDto(@JsonProperty("resourceIds") List<String> resourceIds,
                                        @JsonProperty("accounts") List<DeliveryAccountDto> accounts) {
        this.resourceIds = resourceIds != null ? resourceIds : List.of();
        this.accounts = accounts != null ? accounts : List.of();
    }

    public List<String> getResourceIds() {
        return resourceIds;
    }

    public List<DeliveryAccountDto> getAccounts() {
        return accounts;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliveryResourcesAccountsDto that = (DeliveryResourcesAccountsDto) o;
        return Objects.equals(resourceIds, that.resourceIds) &&
                Objects.equals(accounts, that.accounts);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceIds, accounts);
    }

    @Override
    public String toString() {
        return "DeliveryResourcesAccountsDto{" +
                "resourceIds=" + resourceIds +
                ", accounts=" + accounts +
                '}';
    }

}
