package ru.yandex.qe.dispenser.domain.d;

import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DeliveryStatusAccountDto {

    private final String accountId;
    private final String providerId;
    private final String displayName;
    @Nullable
    private final Set<DeliveryResourceSegmentationSegmentDto> segments;

    @JsonCreator
    public DeliveryStatusAccountDto(
            @JsonProperty("accountId") String accountId,
            @JsonProperty("providerId") String providerId,
            @JsonProperty("displayName") String displayName,
            @JsonProperty("segments") @Nullable Set<DeliveryResourceSegmentationSegmentDto> segments) {
        this.accountId = accountId;
        this.providerId = providerId;
        this.displayName = displayName;
        this.segments = segments;
    }

    public String getAccountId() {
        return accountId;
    }

    public String getProviderId() {
        return providerId;
    }

    public String getDisplayName() {
        return displayName;
    }

    @Nullable
    public Set<DeliveryResourceSegmentationSegmentDto> getSegments() {
        return segments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliveryStatusAccountDto that = (DeliveryStatusAccountDto) o;
        return Objects.equals(accountId, that.accountId) &&
                Objects.equals(providerId, that.providerId) &&
                Objects.equals(displayName, that.displayName) &&
                Objects.equals(segments, that.segments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountId, providerId, displayName, segments);
    }

    @Override
    public String toString() {
        return "DeliveryStatusAccountDto{" +
                "accountId='" + accountId + '\'' +
                ", providerId='" + providerId + '\'' +
                ", displayName='" + displayName + '\'' +
                ", segments=" + segments +
                '}';
    }

}
