package ru.yandex.qe.dispenser.domain.d;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DeliveryStatusDto {

    private final String deliveryId;
    private final List<DeliveryStatusOperationDto> operations;
    private final List<DeliveryStatusAccountDto> accounts;
    private final List<DeliveryStatusProviderDto> providers;
    private final List<DeliveryStatusResourceDto> resources;

    @JsonCreator
    public DeliveryStatusDto(@JsonProperty("deliveryId") String deliveryId,
                             @JsonProperty("operations") List<DeliveryStatusOperationDto> operations,
                             @JsonProperty("accounts") List<DeliveryStatusAccountDto> accounts,
                             @JsonProperty("providers") List<DeliveryStatusProviderDto> providers,
                             @JsonProperty("resources") List<DeliveryStatusResourceDto> resources) {
        this.deliveryId = deliveryId;
        this.operations = operations;
        this.accounts = accounts;
        this.providers = providers;
        this.resources = resources;
    }

    public String getDeliveryId() {
        return deliveryId;
    }

    public List<DeliveryStatusOperationDto> getOperations() {
        return operations;
    }

    public List<DeliveryStatusAccountDto> getAccounts() {
        return accounts;
    }

    public List<DeliveryStatusProviderDto> getProviders() {
        return providers;
    }

    public List<DeliveryStatusResourceDto> getResources() {
        return resources;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliveryStatusDto that = (DeliveryStatusDto) o;
        return Objects.equals(deliveryId, that.deliveryId) &&
                Objects.equals(operations, that.operations) &&
                Objects.equals(accounts, that.accounts) &&
                Objects.equals(providers, that.providers) &&
                Objects.equals(resources, that.resources);
    }

    @Override
    public int hashCode() {
        return Objects.hash(deliveryId, operations, accounts, providers, resources);
    }

    @Override
    public String toString() {
        return "DeliveryStatusDto{" +
                "deliveryId='" + deliveryId + '\'' +
                ", operations=" + operations +
                ", accounts=" + accounts +
                ", providers=" + providers +
                ", resources=" + resources +
                '}';
    }

}
