package ru.yandex.qe.dispenser.domain.d;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DeliveryStatusProviderDto {

    private final String providerId;
    private final String displayName;

    @JsonCreator
    public DeliveryStatusProviderDto(@JsonProperty("providerId") String providerId,
                                     @JsonProperty("displayName") String displayName) {
        this.providerId = providerId;
        this.displayName = displayName;
    }

    public String getProviderId() {
        return providerId;
    }

    public String getDisplayName() {
        return displayName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliveryStatusProviderDto that = (DeliveryStatusProviderDto) o;
        return Objects.equals(providerId, that.providerId) &&
                Objects.equals(displayName, that.displayName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(providerId, displayName);
    }

    @Override
    public String toString() {
        return "DeliveryStatusProviderDto{" +
                "providerId='" + providerId + '\'' +
                ", displayName='" + displayName + '\'' +
                '}';
    }

}
