package ru.yandex.qe.dispenser.domain.d;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DeliveryStatusRequestedQuotasDto {

    private final String resourceId;
    private final DeliveryAmountDto amount;

    @JsonCreator
    public DeliveryStatusRequestedQuotasDto(@JsonProperty("resourceId") String resourceId,
                                            @JsonProperty("amount") DeliveryAmountDto amount) {
        this.resourceId = resourceId;
        this.amount = amount;
    }

    public String getResourceId() {
        return resourceId;
    }

    public DeliveryAmountDto getAmount() {
        return amount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliveryStatusRequestedQuotasDto that = (DeliveryStatusRequestedQuotasDto) o;
        return Objects.equals(resourceId, that.resourceId) &&
                Objects.equals(amount, that.amount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, amount);
    }

    @Override
    public String toString() {
        return "DeliveryStatusRequestedQuotasDto{" +
                "resourceId='" + resourceId + '\'' +
                ", amount=" + amount +
                '}';
    }

}
