package ru.yandex.qe.dispenser.domain.d;

import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DeliveryStatusResourceDto {

    private final String resourceId;
    private final String displayName;
    @Nullable
    private final Set<DeliveryResourceSegmentationSegmentDto> segments;

    @JsonCreator
    public DeliveryStatusResourceDto(
            @JsonProperty("resourceId") String resourceId,
            @JsonProperty("displayName") String displayName,
            @JsonProperty("segments") @Nullable Set<DeliveryResourceSegmentationSegmentDto> segments) {
        this.resourceId = resourceId;
        this.displayName = displayName;
        this.segments = segments;
    }

    public String getResourceId() {
        return resourceId;
    }

    public String getDisplayName() {
        return displayName;
    }

    @Nullable
    public Set<DeliveryResourceSegmentationSegmentDto> getSegments() {
        return segments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliveryStatusResourceDto that = (DeliveryStatusResourceDto) o;
        return Objects.equals(resourceId, that.resourceId) &&
                Objects.equals(displayName, that.displayName) &&
                Objects.equals(segments, that.segments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, displayName, segments);
    }

    @Override
    public String toString() {
        return "DeliveryStatusResourceDto{" +
                "resourceId='" + resourceId + '\'' +
                ", displayName='" + displayName + '\'' +
                ", segments=" + segments +
                '}';
    }

}
