package ru.yandex.qe.dispenser.domain.d;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DeliveryStatusResponseDto {

    @Nullable
    private final List<DeliveryStatusDto> deliveries;

    @JsonCreator
    public DeliveryStatusResponseDto(@JsonProperty("deliveries") @Nullable List<DeliveryStatusDto> deliveries) {
        this.deliveries = deliveries;
    }

    @Nullable
    public List<DeliveryStatusDto> getDeliveries() {
        return deliveries;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliveryStatusResponseDto that = (DeliveryStatusResponseDto) o;
        return Objects.equals(deliveries, that.deliveries);
    }

    @Override
    public int hashCode() {
        return Objects.hash(deliveries);
    }

    @Override
    public String toString() {
        return "DeliveryStatusResponseDto{" +
                "deliveries=" + deliveries +
                '}';
    }

}
