package ru.yandex.qe.dispenser.domain.d;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Provide account dto;
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProvideAccountDto {
    @NotNull
    private final String accountId;
    @NotNull
    private final String providerId;
    @NotNull
    private final String displayName;
    @Nullable
    private final List<ProvideSegmentDto> segments;

    @JsonCreator
    public ProvideAccountDto(
            @JsonProperty(value = "accountId", required = true) @NotNull String accountId,
            @JsonProperty(value = "providerId", required = true) @NotNull String providerId,
            @JsonProperty(value = "displayName", required = true) @NotNull String displayName,
            @JsonProperty("segments") @Nullable List<ProvideSegmentDto> segments) {
        this.accountId = accountId;
        this.providerId = providerId;
        this.displayName = displayName;
        this.segments = segments;
    }

    @NotNull
    public String getAccountId() {
        return accountId;
    }

    @NotNull
    public String getProviderId() {
        return providerId;
    }

    @NotNull
    public String getDisplayName() {
        return displayName;
    }

    @Nullable
    public List<ProvideSegmentDto> getSegments() {
        return segments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProvideAccountDto that = (ProvideAccountDto) o;
        return accountId.equals(that.accountId) && providerId.equals(that.providerId)
                && displayName.equals(that.displayName) && Objects.equals(segments, that.segments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountId, providerId, displayName, segments);
    }

    @Override
    public String toString() {
        return "ProvideAccountDto{" +
                "accountId='" + accountId + '\'' +
                ", providerId='" + providerId + '\'' +
                ", displayName='" + displayName + '\'' +
                ", segments=" + segments +
                '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String accountId;
        private String providerId;
        private String displayName;
        private List<ProvideSegmentDto> segments;

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder providerId(String providerId) {
            this.providerId = providerId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder segments(List<ProvideSegmentDto> segments) {
            this.segments = segments;
            return this;
        }

        public ProvideAccountDto build() {
            return new ProvideAccountDto(
                    Objects.requireNonNull(accountId, "AccountId is required!"),
                    Objects.requireNonNull(providerId, "ProviderId is required!"),
                    Objects.requireNonNull(displayName, "DisplayName is required!"),
                    segments
            );
        }
    }
}
