package ru.yandex.qe.dispenser.domain.d;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

/**
 * Provide delivery dto;
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProvideDeliveryDto {
    private final long serviceId;
    @NotNull
    private final String providerId;
    @NotNull
    private final String folderId;
    @NotNull
    private final String accountId;
    @NotNull
    private final String resourceId;
    @NotNull
    private final DeliverableDeltaDto delta;
    @NotNull
    private final DeliverableMetaRequestDto meta;

    @JsonCreator
    public ProvideDeliveryDto(
            @JsonProperty("serviceId") long serviceId,
            @JsonProperty("providerId") @NotNull String providerId,
            @JsonProperty("folderId") @NotNull String folderId,
            @JsonProperty("accountId") @NotNull String accountId,
            @JsonProperty("resourceId") @NotNull String resourceId,
            @JsonProperty("delta") @NotNull DeliverableDeltaDto delta,
            @JsonProperty("meta") @NotNull DeliverableMetaRequestDto meta) {
        this.serviceId = serviceId;
        this.providerId = providerId;
        this.folderId = folderId;
        this.accountId = accountId;
        this.resourceId = resourceId;
        this.delta = delta;
        this.meta = meta;
    }

    public long getServiceId() {
        return serviceId;
    }

    @NotNull
    public String getProviderId() {
        return providerId;
    }

    @NotNull
    public String getFolderId() {
        return folderId;
    }

    @NotNull
    public String getAccountId() {
        return accountId;
    }

    @NotNull
    public String getResourceId() {
        return resourceId;
    }

    @NotNull
    public DeliverableDeltaDto getDelta() {
        return delta;
    }

    @NotNull
    public DeliverableMetaRequestDto getMeta() {
        return meta;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProvideDeliveryDto that = (ProvideDeliveryDto) o;
        return serviceId == that.serviceId && Objects.equals(providerId, that.providerId) && Objects.equals(folderId,
                that.folderId) && Objects.equals(accountId, that.accountId) && Objects.equals(resourceId,
                that.resourceId) && Objects.equals(delta, that.delta) && Objects.equals(meta, that.meta);
    }

    @Override
    public int hashCode() {
        return Objects.hash(serviceId, providerId, folderId, accountId, resourceId, delta, meta);
    }

    @Override
    public String toString() {
        return "ProvideDeliveryDto{" +
                "serviceId=" + serviceId +
                ", providerId='" + providerId + '\'' +
                ", folderId='" + folderId + '\'' +
                ", accountId='" + accountId + '\'' +
                ", resourceId='" + resourceId + '\'' +
                ", delta=" + delta +
                ", meta=" + meta +
                '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Long serviceId;
        private String providerId;
        private String folderId;
        private String accountId;
        private String resourceId;
        private DeliverableDeltaDto delta;
        private DeliverableMetaRequestDto meta;

        public Builder serviceId(Long serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public Builder providerId(String providerId) {
            this.providerId = providerId;
            return this;
        }

        public Builder folderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder delta(DeliverableDeltaDto delta) {
            this.delta = delta;
            return this;
        }

        public Builder meta(DeliverableMetaRequestDto meta) {
            this.meta = meta;
            return this;
        }

        public ProvideDeliveryDto build() {
            return new ProvideDeliveryDto(
                    Objects.requireNonNull(serviceId, "ServiceId is required!"),
                    Objects.requireNonNull(providerId, "ProviderId is required!"),
                    Objects.requireNonNull(folderId, "FolderId is required!"),
                    Objects.requireNonNull(accountId, "AccountId is required!"),
                    Objects.requireNonNull(resourceId, "ResourceId is required!"),
                    Objects.requireNonNull(delta, "Delta is required!"),
                    Objects.requireNonNull(meta, "Meta is required!"));
        }
    }
}
