package ru.yandex.qe.dispenser.domain.d;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Provide operation error kind.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public enum ProvideOperationErrorKindDto {
    INVALID_ARGUMENT,
    ALREADY_EXISTS,
    FAILED_PRECONDITION,
    UNKNOWN,
    ABORTED,
    UNDEFINED,
    EXPIRED
    ;

    @JsonValue
    public String toJsonValue() {
        return name();
    }

    @JsonCreator
    public static ProvideOperationErrorKindDto fromJsonValue(String value) {
        return ProvideOperationErrorKindDto.valueOf(value);
    }
}
