package ru.yandex.qe.dispenser.domain.d;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Provide operation status.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public enum ProvideOperationStatusDto {
    IN_PROGRESS,
    SUCCESS,
    FAILURE,
    ;

    @JsonValue
    public String toJsonValue() {
        return name();
    }

    @JsonCreator
    public static ProvideOperationStatusDto fromJsonValue(String value) {
        return ProvideOperationStatusDto.valueOf(value);
    }
}
