package ru.yandex.qe.dispenser.domain.d;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

/**
 * Provide provider dto.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProvideProviderDto {
    @NotNull
    private final String providerId;
    @NotNull
    private final String displayName;

    @JsonCreator
    public ProvideProviderDto(@JsonProperty(value = "providerId", required = true)  @NotNull String providerId,
                              @JsonProperty(value = "displayName", required = true) @NotNull String displayName) {
        this.providerId = providerId;
        this.displayName = displayName;
    }

    @NotNull
    public String getProviderId() {
        return providerId;
    }

    @NotNull
    public String getDisplayName() {
        return displayName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProvideProviderDto that = (ProvideProviderDto) o;
        return providerId.equals(that.providerId) && displayName.equals(that.displayName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(providerId, displayName);
    }

    @Override
    public String toString() {
        return "ProvideProviderDto{" +
                "providerId='" + providerId + '\'' +
                ", displayName='" + displayName + '\'' +
                '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String providerId;
        private String displayName;

        public Builder providerId(String providerId) {
            this.providerId = providerId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public ProvideProviderDto build() {
            return new ProvideProviderDto(
                    Objects.requireNonNull(providerId, "ProviderId is required!"),
                    Objects.requireNonNull(displayName, "DisplayName is required!")
            );
        }
    }
}
