package ru.yandex.qe.dispenser.domain.d;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

/**
 * Provide request dto;
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public class ProvideRequestDto {
    @NotNull
    private final String deliveryId;
    @NotNull
    private final String authorUid;
    @NotNull
    private final List<ProvideDeliveryDto> deliverables;

    @JsonCreator
    public ProvideRequestDto(
            @JsonProperty(value = "deliveryId", required = true) @NotNull String deliveryId,
            @JsonProperty(value = "authorUid", required = true) @NotNull String authorUid,
            @JsonProperty(value = "deliverables", required = true) @NotNull List<ProvideDeliveryDto> deliverables) {
        this.deliveryId = deliveryId;
        this.authorUid = authorUid;
        this.deliverables = deliverables;
    }

    @NotNull
    public String getDeliveryId() {
        return deliveryId;
    }

    @NotNull
    public String getAuthorUid() {
        return authorUid;
    }

    @NotNull
    public List<ProvideDeliveryDto> getDeliverables() {
        return deliverables;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProvideRequestDto that = (ProvideRequestDto) o;
        return Objects.equals(deliveryId, that.deliveryId) && Objects.equals(authorUid, that.authorUid) && Objects.equals(deliverables, that.deliverables);
    }

    @Override
    public int hashCode() {
        return Objects.hash(deliveryId, authorUid, deliverables);
    }

    @Override
    public String toString() {
        return "ProvideRequestDto{" +
                "deliveryId='" + deliveryId + '\'' +
                ", authorUid='" + authorUid + '\'' +
                ", deliverables=" + deliverables +
                '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String deliveryId;
        private String authorUid;
        private List<ProvideDeliveryDto> deliverables = new ArrayList<>();

        public Builder deliveryId(String deliveryId) {
            this.deliveryId = deliveryId;
            return this;
        }

        public Builder authorUid(String authorUid) {
            this.authorUid = authorUid;
            return this;
        }

        public Builder delivery(ProvideDeliveryDto deliveryDto) {
            deliverables.add(deliveryDto);
            return this;
        }

        public Builder deliverables(List<ProvideDeliveryDto> deliverables) {
            this.deliverables = deliverables;
            return this;
        }

        public ProvideRequestDto build() {
            return new ProvideRequestDto(
                    Objects.requireNonNull(deliveryId, "deliveryId is required!"),
                    Objects.requireNonNull(authorUid, "authorUid is required!"),
                    Objects.requireNonNull(deliverables, "deliverables is required!")
            );
        }
    }
}
