package ru.yandex.qe.dispenser.domain.d;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

/**
 * Provide requested quota;
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProvideRequestedQuota {
    @NotNull
    private final String resourceId;
    @NotNull
    private final AmountDto amount;

    @JsonCreator
    public ProvideRequestedQuota(
            @JsonProperty(value = "resourceId", required = true) @NotNull String resourceId,
            @JsonProperty(value = "amount", required = true) @NotNull AmountDto amount) {
        this.resourceId = resourceId;
        this.amount = amount;
    }

    @NotNull
    public String getResourceId() {
        return resourceId;
    }

    @NotNull
    public AmountDto getAmount() {
        return amount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProvideRequestedQuota that = (ProvideRequestedQuota) o;
        return Objects.equals(resourceId, that.resourceId) && Objects.equals(amount, that.amount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, amount);
    }

    @Override
    public String toString() {
        return "ProvideRequestedQuota{" +
                "resourceId='" + resourceId + '\'' +
                ", amount=" + amount +
                '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String resourceId;
        private AmountDto amount;

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder amount(AmountDto amount) {
            this.amount = amount;
            return this;
        }

        public ProvideRequestedQuota build() {
            return new ProvideRequestedQuota(
                    Objects.requireNonNull(resourceId, "ResourceId is required!"),
                    Objects.requireNonNull(amount, "Amount is required!")
            );
        }
    }
}
