package ru.yandex.qe.dispenser.domain.d;

import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

/**
 * Provide resource dto.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProvideResourceDto {
    @NotNull
    private final String resourceId;
    @NotNull
    private final String displayName;
    @NotNull
    private final Set<ProvideSegmentDto> segments;

    @JsonCreator
    public ProvideResourceDto(
            @JsonProperty(value = "resourceId", required = true) @NotNull String resourceId,
            @JsonProperty(value = "displayName", required = true) @NotNull String displayName,
            @JsonProperty(value = "segments", required = true) @NotNull Set<ProvideSegmentDto> segments
    ) {
        this.resourceId = resourceId;
        this.displayName = displayName;
        this.segments = segments;
    }

    @NotNull
    public String getResourceId() {
        return resourceId;
    }

    @NotNull
    public String getDisplayName() {
        return displayName;
    }

    @NotNull
    public Set<ProvideSegmentDto> getSegments() {
        return segments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProvideResourceDto that = (ProvideResourceDto) o;
        return resourceId.equals(that.resourceId) && displayName.equals(that.displayName)
                && segments.equals(that.segments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, displayName, segments);
    }

    @Override
    public String toString() {
        return "ProvideResourceDto{" +
                "resourceId='" + resourceId + '\'' +
                ", displayName='" + displayName + '\'' +
                ", segments=" + segments +
                '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String resourceId;
        private String displayName;
        private Set<ProvideSegmentDto> segments;

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder segments(Set<ProvideSegmentDto> segments) {
            this.segments = segments;
            return this;
        }

        public ProvideResourceDto build() {
            return new ProvideResourceDto(
                    Objects.requireNonNull(resourceId, "ResourceId is required!"),
                    Objects.requireNonNull(displayName, "DisplayName is required!"),
                    Objects.requireNonNull(segments, "Segments is required!")
            );
        }
    }
}
