package ru.yandex.qe.dispenser.domain.d;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

/**
 * Provide response dto;
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProvideResponseDto {
    @NotNull
    private final String deliveryId;
    @NotNull
    private final List<ProvideOperationDto> operations;
    @NotNull
    private final List<ProvideAccountDto> accounts;
    @NotNull
    private final List<ProvideProviderDto> providers;
    @NotNull
    private final List<ProvideResourceDto> resources;

    @JsonCreator
    public ProvideResponseDto(
            @JsonProperty(value = "deliveryId", required = true) @NotNull String deliveryId,
            @JsonProperty(value = "operations", required = true) @NotNull List<ProvideOperationDto> operations,
            @JsonProperty(value = "accounts", required = true) @NotNull List<ProvideAccountDto> accounts,
            @JsonProperty(value = "providers", required = true) @NotNull List<ProvideProviderDto> providers,
            @JsonProperty(value = "resources", required = true) @NotNull List<ProvideResourceDto> resources) {
        this.deliveryId = deliveryId;
        this.operations = operations;
        this.accounts = accounts;
        this.providers = providers;
        this.resources = resources;
    }

    @NotNull
    public String getDeliveryId() {
        return deliveryId;
    }

    @NotNull
    public List<ProvideOperationDto> getOperations() {
        return operations;
    }

    @NotNull
    public List<ProvideAccountDto> getAccounts() {
        return accounts;
    }

    @NotNull
    public List<ProvideProviderDto> getProviders() {
        return providers;
    }

    @NotNull
    public List<ProvideResourceDto> getResources() {
        return resources;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProvideResponseDto that = (ProvideResponseDto) o;
        return deliveryId.equals(that.deliveryId) && operations.equals(that.operations)
                && accounts.equals(that.accounts) && providers.equals(that.providers) && resources.equals(that.resources);
    }

    @Override
    public int hashCode() {
        return Objects.hash(deliveryId, operations, accounts, providers, resources);
    }

    @Override
    public String toString() {
        return "ProvideResponseDto{" +
                "deliveryId='" + deliveryId + '\'' +
                ", operations=" + operations +
                ", accounts=" + accounts +
                ", providers=" + providers +
                ", resources=" + resources +
                '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String deliveryId;
        private List<ProvideOperationDto> operations;
        private List<ProvideAccountDto> accounts;
        private List<ProvideProviderDto> providers;
        private List<ProvideResourceDto> resources;

        public Builder deliveryId(String deliveryId) {
            this.deliveryId = deliveryId;
            return this;
        }

        public Builder operations(List<ProvideOperationDto> operations) {
            this.operations = operations;
            return this;
        }

        public Builder accounts(List<ProvideAccountDto> accounts) {
            this.accounts = accounts;
            return this;
        }

        public Builder providers(List<ProvideProviderDto> providers) {
            this.providers = providers;
            return this;
        }

        public Builder resources(List<ProvideResourceDto> resources) {
            this.resources = resources;
            return this;
        }

        public ProvideResponseDto build() {
            return new ProvideResponseDto(
                    Objects.requireNonNull(deliveryId, "DeliveryId is required!"),
                    Objects.requireNonNull(operations, "Operations are required!"),
                    Objects.requireNonNull(accounts, "Accounts is required!"),
                    Objects.requireNonNull(providers, "Providers are required!"),
                    Objects.requireNonNull(resources, "Resources are required!")
            );
        }
    }
}
