package ru.yandex.qe.dispenser.domain.d;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Provide segment dto;
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProvideSegmentDto {
    @NotNull
    private final String segmentationId;
    @Nullable
    private final String segmentationName;
    @Nullable
    private final Integer groupingOrder;
    @NotNull
    private final String segmentId;
    @Nullable
    private final String segmentName;

    @JsonCreator
    public ProvideSegmentDto(
            @JsonProperty(value = "segmentationId", required = true) @NotNull String segmentationId,
            @JsonProperty("segmentationName") @Nullable String segmentationName,
            @JsonProperty("groupingOrder") @Nullable Integer groupingOrder,
            @JsonProperty(value = "segmentId", required = true) @NotNull String segmentId,
            @JsonProperty("segmentName") @Nullable String segmentName) {
        this.segmentationId = segmentationId;
        this.segmentationName = segmentationName;
        this.groupingOrder = groupingOrder;
        this.segmentId = segmentId;
        this.segmentName = segmentName;
    }

    @NotNull
    public String getSegmentationId() {
        return segmentationId;
    }

    @Nullable
    public String getSegmentationName() {
        return segmentationName;
    }

    @Nullable
    public Integer getGroupingOrder() {
        return groupingOrder;
    }

    @NotNull
    public String getSegmentId() {
        return segmentId;
    }

    @Nullable
    public String getSegmentName() {
        return segmentName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProvideSegmentDto that = (ProvideSegmentDto) o;
        return segmentationId.equals(that.segmentationId) && Objects.equals(segmentationName, that.segmentationName)
                && Objects.equals(groupingOrder, that.groupingOrder) && segmentId.equals(that.segmentId)
                && Objects.equals(segmentName, that.segmentName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(segmentationId, segmentationName, groupingOrder, segmentId, segmentName);
    }

    @Override
    public String toString() {
        return "ProvideSegmentDto{" +
                "segmentationId='" + segmentationId + '\'' +
                ", segmentationName='" + segmentationName + '\'' +
                ", groupingOrder=" + groupingOrder +
                ", segmentId='" + segmentId + '\'' +
                ", segmentName='" + segmentName + '\'' +
                '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    private static class Builder {
        private String segmentationId;
        private String segmentationName;
        private Integer groupingOrder;
        private String segmentId;
        private String segmentName;

        public Builder segmentationId(String segmentationId) {
            this.segmentationId = segmentationId;
            return this;
        }

        public Builder segmentationName(String segmentationName) {
            this.segmentationName = segmentationName;
            return this;
        }

        public Builder groupingOrder(Integer groupingOrder) {
            this.groupingOrder = groupingOrder;
            return this;
        }

        public Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public Builder segmentName(String segmentName) {
            this.segmentName = segmentName;
            return this;
        }

        public ProvideSegmentDto build() {
            return new ProvideSegmentDto(
                    Objects.requireNonNull(segmentationId, "SegmentationId is required!"),
                    segmentationName,
                    groupingOrder,
                    Objects.requireNonNull(segmentId, "SegmentId is required!"),
                    segmentName
            );
        }
    }
}
