package ru.yandex.qe.dispenser.domain.dao;

import java.io.Serializable;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;

import org.jetbrains.annotations.NotNull;

public interface InMemoryDao<T, PK extends Serializable> extends GenericDao<T, PK> {
    @NotNull
    Set<T> getAll();

    default int size() {
        return getAll().size();
    }

    default boolean isEmpty() {
        return size() == 0;
    }

    @NotNull
    default Stream<T> filter(@NotNull final Predicate<T> predicate) {
        return getAll().stream().filter(predicate);
    }

    @Override
    default boolean clear() {
        return deleteAll(getAll());
    }
}
