package ru.yandex.qe.dispenser.domain.dao;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.dao.EmptyResultDataAccessException;

import ru.yandex.qe.dispenser.api.Keyable;
import ru.yandex.qe.dispenser.domain.util.StreamUtils;

public interface ReadOnlyDao<T extends Keyable<K>, K extends Comparable<K>, PK extends Serializable> {
    @NotNull
    T read(@NotNull PK id) throws EmptyResultDataAccessException;

    @NotNull
    T read(@NotNull K key) throws EmptyResultDataAccessException;

    @Nullable
    default T readOrNull(@NotNull final K key) {
        try {
            return read(key);
        } catch (EmptyResultDataAccessException ignored) {
            return null;
        }
    }

    default boolean contains(@NotNull final K key) {
        return readOrNull(key) != null;
    }

    @NotNull
    default Map<K, T> readAll(@NotNull final Collection<K> keys) throws EmptyResultDataAccessException {
        return StreamUtils.toMap(keys.stream().sorted().distinct().map(this::read), Keyable::getKey);
    }

    @NotNull
    default Map<K, T> readPresent(@NotNull final Collection<K> keys) {
        return StreamUtils.toMap(keys.stream().sorted().distinct().map(this::readOrNull).filter(Objects::nonNull), Keyable::getKey);
    }

    interface Normalized<T extends Keyable<K>, K extends Comparable<K>> extends ReadOnlyDao<T, K, Long> {
    }
}
