package ru.yandex.qe.dispenser.domain.dao.base_resources;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;

import org.jetbrains.annotations.TestOnly;

import ru.yandex.qe.dispenser.domain.base_resources.BaseResourceChange;

public interface BaseResourceChangeDao {

    BaseResourceChange create(BaseResourceChange.Builder builder);

    Set<BaseResourceChange> create(Collection<? extends BaseResourceChange.Builder> builders);

    Optional<BaseResourceChange> getById(long id);

    Set<BaseResourceChange> getByIds(Collection<? extends Long> ids);

    Set<BaseResourceChange> getByQuotaRequestId(long quotaRequestId);

    Set<BaseResourceChange> getByQuotaRequestIds(Collection<? extends Long> quotaRequestIds);

    Optional<BaseResourceChange> update(BaseResourceChange.Update update);

    Set<BaseResourceChange> update(Collection<? extends BaseResourceChange.Update> updates);

    Optional<BaseResourceChange> deleteById(long id);

    Set<BaseResourceChange> deleteByIds(Collection<? extends Long> ids);

    @TestOnly
    void clear();

}
