package ru.yandex.qe.dispenser.domain.dao.base_resources;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;

import org.jetbrains.annotations.TestOnly;

import ru.yandex.qe.dispenser.domain.base_resources.BaseResource;

public interface BaseResourceDao {

    BaseResource create(BaseResource.Builder builder);

    Optional<BaseResource> getById(long id);

    Set<BaseResource> getByIds(Collection<? extends Long> ids);

    List<BaseResource> getPage(Long idFrom, int size);

    Set<BaseResource> getByBaseResourceTypeIds(Collection<? extends Long> ids);

    Optional<BaseResource> getByKey(String key);

    Set<BaseResource> getByKeys(Collection<? extends String> keys);

    @TestOnly
    void clear();

}
