package ru.yandex.qe.dispenser.domain.dao.base_resources;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;

import org.jetbrains.annotations.TestOnly;

import ru.yandex.qe.dispenser.domain.base_resources.BaseResourceLimit;

public interface BaseResourceLimitDao {

    BaseResourceLimit create(BaseResourceLimit.Builder builder);

    Set<BaseResourceLimit> create(Collection<? extends BaseResourceLimit.Builder> builders);

    Optional<BaseResourceLimit> getById(long id);

    Set<BaseResourceLimit> getByIds(Collection<? extends Long> ids);

    List<BaseResourceLimit> getPage(Long idFrom, int size);

    Set<BaseResourceLimit> getByCampaign(long campaignId);

    Set<BaseResourceLimit> getByCampaigns(Collection<? extends Long> campaignIds);

    Optional<BaseResourceLimit> update(BaseResourceLimit.Update update);

    Set<BaseResourceLimit> update(Collection<? extends BaseResourceLimit.Update> updates);

    Optional<BaseResourceLimit> deleteById(long id);

    Set<BaseResourceLimit> deleteByIds(Collection<? extends Long> ids);

    Optional<BaseResourceLimit> getByKey(BaseResourceLimit.Key key);

    Set<BaseResourceLimit> getByCampaignAndBaseResources(long campaignId, Collection<? extends Long> baseResourceIds);

    @TestOnly
    void clear();

}
