package ru.yandex.qe.dispenser.domain.dao.base_resources;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;

import org.jetbrains.annotations.TestOnly;

import ru.yandex.qe.dispenser.domain.base_resources.BaseResourceMapping;

public interface BaseResourceMappingDao {

    BaseResourceMapping create(BaseResourceMapping.Builder builder);

    Optional<BaseResourceMapping> getById(long id);

    Set<BaseResourceMapping> getByIds(Collection<? extends Long> ids);

    List<BaseResourceMapping> getPage(Long idFrom, int size);

    Set<BaseResourceMapping> getByCampaign(long campaignId);

    Set<BaseResourceMapping> getByCampaigns(Collection<? extends Long> campaignIds);

    Set<Long> getMappedBaseResourceIds(long campaignId, Collection<? extends Long> baseResourceIds);

    @TestOnly
    void clear();

}
