package ru.yandex.qe.dispenser.domain.dao.base_resources;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;

import org.jetbrains.annotations.TestOnly;

import ru.yandex.qe.dispenser.domain.base_resources.BaseResourceType;

public interface BaseResourceTypeDao {

    BaseResourceType create(BaseResourceType.Builder builder);

    Optional<BaseResourceType> getById(long id);

    Set<BaseResourceType> getByIds(Collection<? extends Long> ids);

    List<BaseResourceType> getPage(Long idFrom, int size);

    Set<BaseResourceType> getByServiceId(long serviceId);

    Optional<BaseResourceType> getByIdForUpdate(long id);

    Set<BaseResourceType> getByServiceIdForUpdate(long serviceId);

    @TestOnly
    void clear();

}
