package ru.yandex.qe.dispenser.domain.dao.bot;

import ru.yandex.qe.dispenser.domain.bot.Configuration;
import ru.yandex.qe.dispenser.domain.index.LongIndexable;

public abstract class BotConfiguration<T extends Configuration> implements LongIndexable {

    private final T configuration;
    private final Long price;
    private final boolean deletedInBot;
    private final Long resourceComponentsPrice;

    protected BotConfiguration(final T configuration, final Long price, final Long resourceComponentsPrice, final boolean deletedInBot) {
        this.configuration = configuration;
        this.price = price;
        this.resourceComponentsPrice = resourceComponentsPrice;
        this.deletedInBot = deletedInBot;
    }

    public long getId() {
        return configuration.getId();
    }

    public T getConfiguration() {
        return configuration;
    }

    public Long getPrice() {
        return price;
    }

    public Long getResourceComponentsPrice() {
        return resourceComponentsPrice;
    }

    public boolean isDeletedInBot() {
        return deletedInBot;
    }

    public abstract boolean isWithComponents();

    public abstract BotConfiguration<T> withDeletedInBot(final boolean deletedInBot);

    @Override
    public int hashCode() {
        return 31 * configuration.hashCode() + price.hashCode();
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final BotConfiguration<?> other = (BotConfiguration<?>) o;
        return this.configuration.equals(other.configuration) && this.price.equals(other.price);
    }

    @Override
    public String toString() {
        return configuration.getFullName() + " (" + configuration.getId() + ")";
    }
}
