package ru.yandex.qe.dispenser.domain.dao.bot;

import ru.yandex.qe.dispenser.domain.bot.ConfigurationWithComponents;

public class CompleteBotConfiguration extends BotConfiguration<ConfigurationWithComponents> {

    public CompleteBotConfiguration(final ConfigurationWithComponents configuration, final Long price, final Long resourceComponentsPrice) {
        this(configuration, price, resourceComponentsPrice, false);
    }

    public CompleteBotConfiguration(final ConfigurationWithComponents configuration, final Long price, final Long resourceComponentsPrice, final boolean deletedInBot) {
        super(configuration, price, resourceComponentsPrice, deletedInBot);
    }

    @Override
    public boolean isWithComponents() {
        return true;
    }

    public boolean isNew() {
        return true;
    }

    @Override
    public CompleteBotConfiguration withDeletedInBot(final boolean deletedInBot) {
        return new CompleteBotConfiguration(getConfiguration(), getPrice(), getResourceComponentsPrice(), deletedInBot);
    }
}
