package ru.yandex.qe.dispenser.domain.dao.bot;

import org.apache.commons.lang3.builder.CompareToBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.yandex.qe.dispenser.domain.Segment;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.index.NormalizedPrimaryKeyBase;

import java.io.Serializable;
import java.util.Objects;

public class ServersRemainder extends NormalizedPrimaryKeyBase<ServersRemainder.Key> {
    private final double serverCount;
    private final double storageCount;
    private final double price;
    private final boolean upgrade;

    public ServersRemainder(@NotNull final Service service,
                            @NotNull final Segment segment,
                            @NotNull final String groupKey,
                            @Nullable final Long serverId,
                            @Nullable final Long storageId,
                            final double serverCount,
                            final double storageCount,
                            final double price,
                            final long botCampaignGroupId,
                            final boolean upgrade) {
        super(new Key(service, segment, groupKey, serverId, storageId, botCampaignGroupId));
        this.serverCount = serverCount;
        this.price = price;
        this.storageCount = storageCount;
        this.upgrade = upgrade;
    }

    public Service getService() {
        return getKey().getService();
    }

    public Segment getSegment() {
        return getKey().getSegment();
    }

    public String getGroupKey() {
        return getKey().getGroupKey();
    }

    @Nullable
    public Long getServerId() {
        return getKey().getServerId();
    }

    @Nullable
    public Long getStorageId() {
        return getKey().getStorageId();
    }

    public double getServerCount() {
        return serverCount;
    }

    public double getStorageCount() {
        return storageCount;
    }

    public double getPrice() {
        return price;
    }

    public boolean isUpgrade() {
        return upgrade;
    }

    public long getBotCampaignGroupId() {
        return getKey().getBotCampaignGroupId();
    }

    public static class Key implements Comparable<Key>, Serializable {
        private final Service service;
        private final Segment segment;
        private final String groupKey;
        private final Long serverId;
        private final Long storageId;
        private final long botCampaignGroupId;

        public Key(Service service, Segment segment, String groupKey, Long serverId, Long storageId, long botCampaignGroupId) {
            this.service = service;
            this.segment = segment;
            this.groupKey = groupKey;
            this.serverId = serverId;
            this.storageId = storageId;
            this.botCampaignGroupId = botCampaignGroupId;
        }

        public Service getService() {
            return service;
        }

        public Segment getSegment() {
            return segment;
        }

        public String getGroupKey() {
            return groupKey;
        }

        public Long getServerId() {
            return serverId;
        }

        public Long getStorageId() {
            return storageId;
        }

        public long getBotCampaignGroupId() {
            return botCampaignGroupId;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key) o;
            return getBotCampaignGroupId() == key.getBotCampaignGroupId()
                    && Objects.equals(getService(), key.getService())
                    && Objects.equals(getSegment(), key.getSegment())
                    && Objects.equals(getGroupKey(), key.getGroupKey())
                    && Objects.equals(getServerId(), key.getServerId())
                    && Objects.equals(getStorageId(), key.getStorageId());
        }

        @Override
        public int hashCode() {
            return Objects.hash(getService(), getSegment(), getGroupKey(), getServerId(), getStorageId(), getBotCampaignGroupId());
        }

        @Override
        public int compareTo(@NotNull ServersRemainder.Key o) {
            return new CompareToBuilder()
                    .append(getService(), o.getService())
                    .append(getSegment(), o.getSegment())
                    .append(getGroupKey(), o.getGroupKey())
                    .append(getServerId(), o.getServerId())
                    .append(getStorageId(), o.getStorageId())
                    .build();
        }
    }
}
